/*
 * Decompiled with CFR 0.152.
 */
package TurtleGraphics;

import TurtleGraphics.Pen;
import TurtleGraphics.SketchPad;
import java.awt.Color;

public abstract class AbstractPen
implements Pen {
    protected double xPos;
    protected double yPos;
    protected double direction;
    protected int width;
    protected boolean isDown;
    protected Color color;
    protected SketchPad pad;

    public AbstractPen(SketchPad sketchPad) {
        this.pad = sketchPad;
        this.isDown = true;
        this.color = Color.blue;
        this.width = 2;
        this.home();
    }

    public void down() {
        this.isDown = true;
    }

    public abstract void drawString(String var1);

    public void home() {
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.direction = 90.0;
    }

    public void move(double d) {
        this.drawLine(this.xDestination(d), this.yDestination(d));
    }

    public void move(double d, double d2) {
        this.turn(d, d2);
        this.drawLine(d, d2);
    }

    public boolean isDown() {
        return this.isDown;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setDirection(double d) {
        this.direction = d % 360.0;
    }

    public void setWidth(int n) {
        if (n < 1) {
            throw new RuntimeException("Width " + n + " is invalid -- must be >= 1");
        }
        this.width = n;
    }

    public String toString() {
        return "Position: " + this.xPos + ", " + this.yPos + " " + "\nColor: " + this.color + " " + "\nWidth: " + this.width + " " + "\nIs down: " + this.isDown + " " + "\nDirection: " + this.direction;
    }

    public void turn(double d) {
        this.direction = (this.direction + d) % 360.0;
    }

    public void up() {
        this.isDown = false;
    }

    protected abstract void drawLine(double var1, double var3);

    protected void turn(double d, double d2) {
        if (this.xPos == d && this.yPos == d2) {
            return;
        }
        double d3 = d - this.xPos;
        double d4 = d2 - this.yPos;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        this.direction = Math.toDegrees(Math.asin(Math.abs(d4) / d5));
        if (d4 < 0.0) {
            this.direction = -this.direction;
        }
        if (d3 < 0.0) {
            this.direction = 180.0 - this.direction;
        }
    }

    private double xDestination(double d) {
        return this.xPos + d * Math.cos(Math.toRadians(this.direction));
    }

    private double yDestination(double d) {
        return this.yPos + d * Math.sin(Math.toRadians(this.direction));
    }
}

