/*
 * Decompiled with CFR 0.152.
 */
package TurtleGraphics;

import TurtleGraphics.Command;
import TurtleGraphics.CommandDrawLine;
import TurtleGraphics.CommandDrawString;
import TurtleGraphics.CommandSetColor;
import TurtleGraphics.CommandSetPenWidth;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

public class SketchPad
extends JPanel {
    private List commands = new LinkedList();

    public SketchPad() {
        this.setBackground(Color.white);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        for (Command command : this.commands) {
            command.doCommand((Graphics2D)graphics, this.getWidth(), this.getHeight());
        }
    }

    public void setColor(Color color) {
        this.commands.add(new CommandSetColor(color));
    }

    public void setPenWidth(int n) {
        this.commands.add(new CommandSetPenWidth(n));
    }

    public void drawLine(double d, double d2, double d3, double d4, Color color, int n) {
        this.commands.add(new CommandDrawLine(d, d2, d3, d4));
        this.repaint();
    }

    public void drawString(String string, double d, double d2, Color color) {
        this.commands.add(new CommandDrawString(string, d, d2));
        this.repaint();
    }
}

