/*
 * Decompiled with CFR 0.152.
 */
package TurtleGraphics;

import TurtleGraphics.SketchPad;
import TurtleGraphics.SketchPadWindow;
import TurtleGraphics.StandardPen;
import java.awt.Container;

public class WigglePen
extends StandardPen {
    private int numWiggles = 5;
    private double wiggleAngle = 30.0;

    public WigglePen() {
    }

    public WigglePen(SketchPad sketchPad, int n, double d) {
        super(sketchPad);
        this.numWiggles = n;
        this.wiggleAngle = d;
    }

    public WigglePen(SketchPadWindow sketchPadWindow) {
        this(new SketchPad(), 5, 30.0);
        Container container = sketchPadWindow.getContentPane();
        container.add(this.pad);
        sketchPadWindow.setVisible(true);
    }

    public void move(double d) {
        double d2 = this.wiggleAngle / 2.0;
        double d3 = d / ((double)this.numWiggles * 2.0 * Math.cos(Math.PI * d2 / 180.0));
        this.turn(d2);
        for (int i = 1; i <= this.numWiggles; ++i) {
            this.turn(-this.wiggleAngle);
            super.move(d3);
            this.turn(this.wiggleAngle);
            super.move(d3);
        }
        this.turn(-d2);
    }

    public void move(double d, double d2) {
        double d3 = d - this.xPos;
        double d4 = d2 - this.yPos;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        this.turn(d, d2);
        this.move(d5);
    }
}

